/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.services;

import de.willuhn.boot.BootLoader;
import de.willuhn.boot.Bootable;
import de.willuhn.boot.SkipServiceException;
import de.willuhn.jameica.search.SearchProvider;
import de.willuhn.jameica.search.SearchResult;
import de.willuhn.jameica.services.BeanService;
import de.willuhn.jameica.services.PluginService;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.Settings;
import de.willuhn.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SearchService
implements Bootable {
    private ArrayList<SearchProvider> providers = null;
    private static Settings settings = new Settings(SearchService.class);

    public Class[] depends() {
        return new Class[]{PluginService.class};
    }

    public void init(BootLoader loader, Bootable caller) throws SkipServiceException {
        this.providers = new ArrayList();
        try {
            Logger.info((String)"looking for search providers");
            Class[] providers = Application.getClassLoader().getClassFinder().findImplementors(SearchProvider.class);
            BeanService beanService = (BeanService)Application.getBootLoader().getBootable(BeanService.class);
            int count = 0;
            for (int i = 0; i < providers.length; ++i) {
                try {
                    SearchProvider p = (SearchProvider)beanService.get(providers[i]);
                    Logger.debug((String)("  " + p.getName()));
                    this.providers.add(p);
                    ++count;
                    continue;
                }
                catch (Throwable t) {
                    Logger.error((String)("unable to load search provider " + providers[i].getName()), (Throwable)t);
                }
            }
            Collections.sort(this.providers, new Comparator<SearchProvider>(){

                @Override
                public int compare(SearchProvider o1, SearchProvider o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            Logger.info((String)("loaded " + count + " search providers"));
        }
        catch (ClassNotFoundException ne) {
            Logger.info((String)"no search providers found");
        }
    }

    public void shutdown() {
        this.providers = null;
    }

    public List<SearchResult> search(String text) {
        ArrayList<SearchResult> result = new ArrayList<SearchResult>();
        if (text == null || text.length() == 0) {
            return result;
        }
        Logger.debug((String)("searching for " + text));
        for (int i = 0; i < this.providers.size(); ++i) {
            SearchProvider p = this.providers.get(i);
            if (!this.isEnabled(p)) continue;
            result.add(new SearchResult(p, text));
        }
        Logger.debug((String)"search completed");
        return result;
    }

    public SearchProvider[] getSearchProviders() {
        if (this.providers == null) {
            return new SearchProvider[0];
        }
        return this.providers.toArray(new SearchProvider[this.providers.size()]);
    }

    public void setEnabled(SearchProvider provider, boolean enabled) {
        if (provider == null) {
            return;
        }
        settings.setAttribute(provider.getClass().getName() + ".enabled", enabled);
    }

    public boolean isEnabled(SearchProvider provider) {
        if (provider == null) {
            return false;
        }
        return settings.getBoolean(provider.getClass().getName() + ".enabled", true);
    }
}

